Type POINTAPI  '4 Bytes - Synonymous with LONG
        x As Integer
        y As Integer
End Type
'  Message structure
Type MSG    '18 Bytes
        hWnd As Integer
        message As Integer
        wParam As Integer
        lParam As Long
        time As Long
        pt As POINTAPI
End Type
Declare Sub DragAcceptFiles Lib "SHELL.DLL" (ByVal hWnd%, ByVal fAccept%)
Declare Function GetMessagePos% Lib "User" ()
Declare Function DragQueryFile% Lib "SHELL.DLL" (ByVal hdrop%, ByVal iFile%, ByVal lpszFile$, ByVal cb%)
Declare Sub DragFinish Lib "SHELL.DLL" (ByVal hdrop%)
Declare Function DragQueryPoint% Lib "SHELL.DLL" (ByVal hdrop%, lppt As POINTAPI)
Declare Function PeekMessage% Lib "User" (lpMsg As MSG, ByVal hWnd%, ByVal wMsgFilterMin%, ByVal wMsgFilterMax%, ByVal wRemoveMsg%)
Global endit%
Global Const WM_DROPFILES = &H233
''  PeekMessage() Options
Global Const PM_NOREMOVE = &H0
Global Const PM_REMOVE = &H1
Global Const PM_NOYIELD = &H2
''  ShowWindow() Commands
Global Const SW_HIDE = 0
Global Const SW_SHOWNORMAL = 1
Global Const SW_NORMAL = 1
Global Const SW_SHOWMINIMIZED = 2
Global Const SW_SHOWMAXIMIZED = 3
Global Const SW_MAXIMIZE = 3
Global Const SW_SHOWNOACTIVATE = 4
Global Const SW_SHOW = 5
Global Const SW_MINIMIZE = 6
Global Const SW_SHOWMINNOACTIVE = 7
Global Const SW_SHOWNA = 8
Global Const SW_RESTORE = 9

''  Old ShowWindow() Commands
Global Const HIDE_WINDOW = 0
Global Const SHOW_OPENWINDOW = 1
Global Const SHOW_ICONWINDOW = 2
Global Const SHOW_FULLSCREEN = 3
Global Const SHOW_OPENNOACTIVATE = 4

Global MyHwnd%, sourcetag%

' Key Codes
Global Const KEY_LBUTTON = &H1
Global Const KEY_RBUTTON = &H2
Global Const KEY_CANCEL = &H3
Global Const KEY_MBUTTON = &H4    ' NOT contiguous with L & RBUTTON
Global Const KEY_BACK = &H8
Global Const KEY_TAB = &H9
Global Const KEY_CLEAR = &HC
Global Const KEY_RETURN = &HD
Global Const KEY_SHIFT = &H10
Global Const KEY_CONTROL = &H11
Global Const KEY_MENU = &H12
Global Const KEY_PAUSE = &H13
Global Const KEY_CAPITAL = &H14
Global Const KEY_ESCAPE = &H1B
Global Const KEY_SPACE = &H20
Global Const KEY_PRIOR = &H21
Global Const KEY_NEXT = &H22
Global Const KEY_END = &H23
Global Const KEY_HOME = &H24
Global Const KEY_LEFT = &H25
Global Const KEY_UP = &H26
Global Const KEY_RIGHT = &H27
Global Const KEY_DOWN = &H28
Global Const KEY_SELECT = &H29
Global Const KEY_PRINT = &H2A
Global Const KEY_EXECUTE = &H2B
Global Const KEY_SNAPSHOT = &H2C
Global Const KEY_INSERT = &H2D
Global Const KEY_DELETE = &H2E
Global Const KEY_HELP = &H2F

' KEY_A thru KEY_Z are the same as their ASCII equivalents: 'A' thru 'Z'
' KEY_0 thru KEY_9 are the same as their ASCII equivalents: '0' thru '9'

Global Const KEY_NUMPAD0 = &H60
Global Const KEY_NUMPAD1 = &H61
Global Const KEY_NUMPAD2 = &H62
Global Const KEY_NUMPAD3 = &H63
Global Const KEY_NUMPAD4 = &H64
Global Const KEY_NUMPAD5 = &H65
Global Const KEY_NUMPAD6 = &H66
Global Const KEY_NUMPAD7 = &H67
Global Const KEY_NUMPAD8 = &H68
Global Const KEY_NUMPAD9 = &H69
Global Const KEY_MULTIPLY = &H6A
Global Const KEY_ADD = &H6B
Global Const KEY_SEPARATOR = &H6C
Global Const KEY_SUBTRACT = &H6D
Global Const KEY_DECIMAL = &H6E
Global Const KEY_DIVIDE = &H6F
Global Const KEY_F1 = &H70
Global Const KEY_F2 = &H71
Global Const KEY_F3 = &H72
Global Const KEY_F4 = &H73
Global Const KEY_F5 = &H74
Global Const KEY_F6 = &H75
Global Const KEY_F7 = &H76
Global Const KEY_F8 = &H77
Global Const KEY_F9 = &H78
Global Const KEY_F10 = &H79
Global Const KEY_F11 = &H7A
Global Const KEY_F12 = &H7B
Global Const KEY_F13 = &H7C
Global Const KEY_F14 = &H7D
Global Const KEY_F15 = &H7E
Global Const KEY_F16 = &H7F

Global Const KEY_NUMLOCK = &H90

' MsgBox parameters
Global Const MB_OK = 0                 ' OK button only
Global Const MB_OKCANCEL = 1           ' OK and Cancel buttons
Global Const MB_ABORTRETRYIGNORE = 2   ' Abort, Retry, and Ignore buttons
Global Const MB_YESNOCANCEL = 3        ' Yes, No, and Cancel buttons
Global Const MB_YESNO = 4              ' Yes and No buttons
Global Const MB_RETRYCANCEL = 5        ' Retry and Cancel buttons

Global Const MB_ICONSTOP = 16          ' Critical message
Global Const MB_ICONQUESTION = 32      ' Warning query
Global Const MB_ICONEXCLAMATION = 48   ' Warning message
Global Const MB_ICONINFORMATION = 64   ' Information message

Global Const MB_APPLMODAL = 0          ' Application Modal Message Box
Global Const MB_DEFBUTTON1 = 0         ' First button is default
Global Const MB_DEFBUTTON2 = 256       ' Second button is default
Global Const MB_DEFBUTTON3 = 512       ' Third button is default
Global Const MB_SYSTEMMODAL = 4096      'System Modal

' MsgBox return values
Global Const IDOK = 1                  ' OK button pressed
Global Const IDCANCEL = 2              ' Cancel button pressed
Global Const IDABORT = 3               ' Abort button pressed
Global Const IDRETRY = 4               ' Retry button pressed
Global Const IDIGNORE = 5              ' Ignore button pressed
Global Const IDYES = 6                 ' Yes button pressed
Global Const IDNO = 7                  ' No button pressed

Global SettingsOn%
Global lFile$

Function ExtractFile (ByVal Pathname As String) As String
    Dim f$, N%
' Return the filename portion of a full pathname

    f$ = Pathname

    Do
        N% = InStr(f$, "\")
        If N% > 0 Then f$ = Right$(f$, Len(f$) - N%)
    Loop While N% > 0

    ExtractFile = f$

End Function

Function ExtractPath$ (Pathname$)
    ' Return the directory path portion of a full pathname
    ' The same function exists in the DLL, but would need just about
    ' as many lines of codes to convert the return value to string
    ' this function is probably simplier to code than to call

    Dim f$
    Dim N As Integer
    f$ = Pathname$

    Do
        N = InStr(f$, "\")
        If N > 0 Then f$ = Right$(f$, Len(f$) - N)
    Loop While N > 0

    ExtractPath$ = Left$(Pathname$, Len(Pathname$) - Len(f$))

End Function

Sub Process (frm As Form, filename$)
    Dim x%, k%
    Dim Value$
    frm.List1.Clear
    x = UsersOfFile(filename$)
    If x = 0 Then
       frm.List1.AddItem "Nobody"
       lFile$ = ""
    Else
       For i = 1 To x
           Value$ = String$(300, Chr$(0))
           k = WhoUsesFile(filename$, i, Value$)
           frm.List1.AddItem Left$(Value$, k)
           lFile$ = filename$
       Next
       frm.List1.ListIndex = 0
    End If
End Sub

Sub SpyMessage (frm As Form)
    Dim DropMessage As MSG
    Dim gotone%
    Dim hdrop%
    Dim filename As String * 128
    Dim numfiles%
    Dim thisfile%, di%
    Dim i%, j%, zo%
    Dim f$, pkSwitch$
    Dim ow%

    ' Go into an infinite loop looking for WM_DROPFILES
    'messages
    DragAcceptFiles frm.Picture1.hWnd, -1
    Do
       gotone% = PeekMessage(DropMessage, 0, WM_DROPFILES, WM_DROPFILES, PM_REMOVE Or PM_NOYIELD)
       If gotone Then  'got a drop message
          'retrieve the handle to the internal dropfiles
          'structure
          hdrop% = DropMessage.wParam
          'Get the number of files
          numfiles% = DragQueryFile(hdrop%, -1, filename$, 127)

          'where was it dropped?
          If DropMessage.hWnd = frm.Picture1.hWnd Or DropMessage.hWnd = frm.List1.hWnd Then
             'frm form
             frm.List1.Visible = True
             frm.Note.Visible = False
              For thisfile% = 1 To numfiles%
                  di% = DragQueryFile(hdrop%, thisfile% - 1, filename$, 127)
                  frm.Caption = "Who uses - " + ExtractFile$(filename$)
                  Process frm, filename$
                  'ask for next
                  If thisfile% <> numfiles% Then
                     MsgBox "Display next?", MB_OK
                  End If
              Next
          End If
          'Dispose of the hdrop% structure
          DragFinish hdrop%
       End If
       di% = DoEvents()
    Loop While endit%
    i = Forms.Count - 1
    SettingsOn = False
    Do While Forms.Count > 0
       Unload Forms(i)
       i = Forms.Count - 1
    Loop
    End
End Sub

